**Status:** Archive (code is provided as-is, no updates expected)

# Meta-MinibatchProx

Step 1. download data.
To save time, we store the data as pkl and then load them into the memory at the beginning. 

***tieredImageNet
Please download the compressed tar files from: https://github.com/renmengye/few-shot-ssl-public
mkdir -p ../tieredImagenet/data
tar -xvf tiered-imagenet.tar
mv *.pkl ../tieredImagenet/data

***miniimagenet
The [fetch_data.sh](fetch_data.sh) script creates a `data/` directory and downloads Mini-ImageNet into it.
The data is on the order of 5GB, so the download takes 10-20 minutes on a reasonably fast internet connection.

***important note
please check whether the dataset path is correct via checking the 'DATA_DIR' flag in the MinibatchProx/args.py.



Step 2. training.

*** tieredImageNet
5-way 1-shot:
python -u run_tieredImageNet.py --lam_reg 10.0 --shots 1 --classes 5 --inner-batch 10 --inner-iters 8 --meta-step 1 --meta-batch 20 --meta-iters 100000 --eval-batch 15 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m51

5-way 5-shot:
python -u run_tieredImageNet.py --lam_reg 10.0 --shots 5 --classes 5 --inner-batch 10 --inner-iters 8 --meta-step 1 --meta-batch 20 --meta-iters 100000 --eval-batch 20 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m55

10-way 1-shot:
python -u run_tieredImageNet.py --lam_reg 10.0 --shots 1 --classes 10 --inner-batch 10 --inner-iters 8 --meta-step 1 --meta-batch 20 --meta-iters 100000 --eval-batch 15 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m101


10-way 5-shot:
python -u run_tieredImageNet.py --lam_reg 10.0 --shots 5 --classes 10 --inner-batch 10 --inner-iters 16 --meta-step 1 --meta-batch 20 --meta-iters 100000 --eval-batch 15 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m105


***miniImageNet
5-way 1-shot:
python -u run_miniimagenet.py --lam_reg 0.10 --shots 1 --classes 5 --inner-batch 10 --inner-iters 8 --meta-step 1 --meta-batch 5 --meta-iters 100000 --eval-batch 5 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m15_miniimagenet

5-way 5-shot:
python -u run_miniimagenet.py --lam_reg 0.10 --shots 5 --classes 5 --inner-batch 10 --inner-iters 8 --meta-step 1 --meta-batch 5 --meta-iters 100000 --eval-batch 15 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m55_miniimagenet

20-way 1-shot:
python -u run_miniimagenet.py --lam_reg 10.0 --shots 1 --classes 20 --inner-batch 20 --inner-iters 16 --meta-step 0.1 --meta-batch 5 --meta-iters 100000 --eval-batch 15 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m201_miniimagenet

20-way 5-shot:
python -u run_miniimagenet.py --lam_reg 10.0 --shots 5 --classes 20 --inner-batch 20 --inner-iters 16 --meta-step 0.1 --meta-batch 5 --meta-iters 100000 --eval-batch 15 --eval-iters 50 --learning-rate 0.001 --meta-step-final 0 --train-shots 15 --checkpoint ckpt_m205_miniimagenet


Step 3. testing.

To evaluate with transduction and non-transduction, you can set the `--transductive` flag. 
